<?php
if(session_status() === PHP_SESSION_NONE){
    session_start();
}

require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/functions.php';

// Verificar que sea usuario
if(empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'user'){
    header('Location: login.php');
    exit;
}
function in_s($k) {
    return trim($_POST[$k] ?? '');
}

$user_id = $_SESSION['user']['id'];


$stmt = $pdo->prepare("
    SELECT descripcion, cantidad, fecha 
    FROM examen_descuentos 
    WHERE user_id = ?
    ORDER BY fecha DESC
");
$stmt->execute([$user_id]);
$descuentos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Panel de Usuario</title>
<link rel="stylesheet" href="assets/css/style_usuario.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="assets/js/app.js"></script>
</head>
<body>
<nav>
    <a href="index.php">Inicio</a> | 
    <a href="logout.php">Salir</a>
</nav>

<h2>Bienvenido <?php echo e($_SESSION['user']['nombre']); ?></h2>
<h3>Mis Descuentos</h3>

<?php if (empty($descuentos)): ?>
    <p>No tienes descuentos asignados actualmente.</p>
<?php else: ?>
<table border="1" cellpadding="7" style="border-collapse: collapse; width: 60%;">
    <tr>
        <th>Descripción</th>
        <th>Descuento</th>
        <th>Fecha</th>
    </tr>
    <?php foreach($descuentos as $d): ?>
    <tr>
        <td><?= e($d['descripcion']) ?></td>
        <td><?= e($d['cantidad']) ?> %</td>
        <td><?= e($d['fecha']) ?></td>
    </tr>
    <?php endforeach; ?>
</table>
<?php endif; ?>

</body>
</html>
