<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

$error = "";
$success = "";

$token = $_GET['token'] ?? '';

if ($token) {
    $stmt = $pdo->prepare("SELECT id, token_expira FROM examen_usuarios WHERE token=?");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        $error = "⚠️ El enlace ya fue usado o es inválido.";
    } elseif (strtotime($user['token_expira']) < time()) {
        $error = "⏳ Este enlace ha expirado.";
    }
} else {
    $error = "El enlace no es válido.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($error)) {
    $password = $_POST['password'] ?? '';
    $confirm  = $_POST['confirm'] ?? '';

    if (strlen($password) < 6) {
        $error = "La contraseña debe tener al menos 6 caracteres.";
    } elseif ($password !== $confirm) {
        $error = "Las contraseñas no coinciden.";
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $nuevo_token = bin2hex(random_bytes(16));

        $stmt = $pdo->prepare("UPDATE examen_usuarios SET password=?, token=?, token_expira=NULL WHERE id=?");
        $stmt->execute([$hash, $nuevo_token, $user['id']]);

        $success = "✅ Contraseña actualizada con éxito. <a href='index.php'>Iniciar sesión</a>";
    }
}
?>

<style>
body {
    background: #f2f5fa;
    font-family: Arial;
    display: flex; justify-content: center; align-items: center;
    height: 100vh; margin: 0;
}
.container {
    background: white; padding: 25px 35px;
    border-radius: 12px; width: 380px; text-align: center;
    box-shadow: 0px 6px 20px rgba(0,0,0,0.15);
}
input {
    width: 100%; padding: 12px; margin-top: 10px;
    border: 1px solid #bbb; border-radius: 6px;
}
button {
    width: 100%; padding: 12px; margin-top: 20px;
    background: #4a6cf7; color: white; border: none;
    border-radius: 6px; cursor: pointer; font-size: 16px;
}
.error { background: #ffe5e5; padding: 10px; color: #d60000; margin-bottom: 15px; border-radius: 6px; }
.success { background: #e5ffe8; padding: 10px; color: #0b6b1b; margin-bottom: 15px; border-radius: 6px; }
</style>

<div class="container">
<h2>Restablecer contraseña</h2>

<?php if($error): ?>
  <div class="error"><?= $error ?></div>
<?php endif; ?>

<?php if($success): ?>
  <div class="success"><?= $success ?></div>
<?php else: ?>
<form method="POST">
  <input type="password" name="password" placeholder="Nueva contraseña" required>
  <input type="password" name="confirm" placeholder="Repetir contraseña" required>
  <button type="submit">Guardar contraseña</button>
</form>
<?php endif; ?>
</div>
